
uniform highp mat4 u_transform;
uniform highp mat4 u_bones[NUM_BONES];
uniform mediump vec2 u_texOffs;

attribute highp vec4 a_position;
attribute mediump vec2 a_texCoord;
attribute mediump vec4 a_weights;
attribute mediump vec4 a_bones;

varying mediump vec2 v_texCoord;

void main()
{
	v_texCoord = a_texCoord + u_texOffs;
	gl_Position = u_transform *
		((u_bones[int(a_bones.x)] * a_weights.x +
		  u_bones[int(a_bones.y)] * a_weights.y +
		  u_bones[int(a_bones.z)] * a_weights.z +
		  u_bones[int(a_bones.w)] * a_weights.w) * a_position);
}
